#pragma once

#if defined(_WIN32)
# define NOMINMAX
# include "targetver.h"

# define _CRT_RAND_S
# ifdef _XBOX_ONE
#  include <xdk.h>
#  if _XDK_EDITION >= 180201 && _XDK_EDITION <= 180707
#   define _SILENCE_CXX17_CODECVT_HEADER_DEPRECATION_WARNING
#  endif
#  include <winrt/Windows.System.h>
#  include <winrt/Windows.UI.Core.h>
#  include <winrt/Windows.Foundation.h>
# else
#  define WIN32_LEAN_AND_MEAN
# endif

// Windows header files
# include <windows.h>
# include <WinSock2.h>
# if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP)
#  include <winhttp.h>
#  define ERROR_INVALID_RESPONSE ERROR_WINHTTP_INVALID_SERVER_RESPONSE
#  undef ERROR_CONNECTION_ABORTED
#  define ERROR_CONNECTION_ABORTED ERROR_WINHTTP_CONNECTION_ERROR
# else
#  define ERROR_INVALID_RESPONSE 12152
# endif
# define ERROR_CANCELED ERROR_CANCELLED
# include <tchar.h>
# define FromPlatformError HRESULT_FROM_WIN32
#elif defined(__ORBIS__)
// PS4 header files
# include <kernel.h>
# include <libsysmodule.h>
# include <libnet/errno.h>

# include <iostream>

# define _countof(a) (sizeof(a) / sizeof((a)[0]))
# define _T(s) s
# define _istalnum isalnum
# define _stprintf_s sprintf_s
# define _stscanf_s sscanf_s
# define _tcschr strchr
# define _totlower tolower
# define UNREFERENCED_PARAMETER(p) ((void)p)

using TCHAR = char;
using LPTSTR = TCHAR*;
using LPCTSTR = TCHAR const*;

// Missing error code macros
# define ERROR_SUCCESS 0
# define ERROR_ACCESS_DENIED EACCES
# define ERROR_BAD_ARGUMENTS EINVAL
# define ERROR_CANCELED ECANCELED
# define ERROR_CONNECTION_ABORTED ECONNABORTED
# define ERROR_INVALID_OPERATION EOPNOTSUPP
# define ERROR_INVALID_RESPONSE EBADMSG
# define ERROR_INVALID_STATE EDOOFUS
# define ERROR_TIMEOUT ETIMEDOUT

# define FromPlatformError(error) SCE_ERROR_MAKE_ERROR(0, error)

inline unsigned GetTickCount() {
	auto time = sceKernelGetProcessTime();
	return static_cast<unsigned>(time / 1'000);
}
#else
# error "unknown platform"
#endif

#include <cassert>
#include <cstdlib>
#include <ctime>
#include <algorithm>
#include <atomic>
#include <chrono>
#ifdef _UNICODE
# ifndef _WIN32
#  include <codecvt>
# endif
#endif
#include <condition_variable>
#include <deque>
#include <exception>
#include <fstream>
#include <functional>
#include <future>
#include <iomanip>
#include <ios>
#include <limits>
#include <memory>
#include <mutex>
#include <random>
#include <regex>
#include <stdexcept>
#include <string>
#include <sstream>
#include <thread>
#include <tuple>
#include <vector>

#ifdef _UNICODE
# define to_tstring std::to_wstring
using tistream = std::wistream;
using tistringstream = std::wistringstream;
using tofstream = std::wofstream;
using tostream = std::wostream;
using tostringstream = std::wostringstream;
using tregex = std::wregex;
using tstringstream = std::wstringstream;
#else
# define to_tstring std::to_string
using tistream = std::istream;
using tistringstream = std::istringstream;
using tofstream = std::ofstream;
using tostream = std::ostream;
using tostringstream = std::ostringstream;
using tregex = std::regex;
using tstringstream = std::stringstream;
#endif

#ifdef _DEBUG
# define verify assert
#else
# define verify(expr) ((void)(expr))
#endif

#include "Internal.h"
