#include "stdafx.h"
#include "resource.h"
#include "ClientAuthDialog.h"

using namespace Twitch;

extern tstring accessToken, clientId;

namespace {
	ClientAuth auth;
	constexpr UINT WM_SET_TOKEN = WM_USER + 111;

	auto StartAuthImpl(HWND dialog) {
		Button_Enable(GetDlgItem(dialog, IDOK), FALSE);
		clientId.clear();
		TCHAR clientId_[99], redirectUri[99], scopes[99];
		GetDlgItemText(dialog, IDC_CLIENT_ID, clientId_, _countof(clientId_));
		GetDlgItemText(dialog, IDC_REDIRECT_URI, redirectUri, _countof(redirectUri));
		GetDlgItemText(dialog, IDC_SCOPES, scopes, _countof(scopes));
		auto task = auth.StartAuth(clientId_, redirectUri, { scopes });
		auto onSuccess = [dialog, clientId_ = tstring(clientId_)](tstring const& token) {
			accessToken = token;
			if(!token.empty()) {
				clientId = clientId_;
			}
			PostMessage(dialog, WM_SET_TOKEN, 0, 0);
		};
		auto onFailure = [dialog](std::exception_ptr pex) {
			try {
				std::rethrow_exception(pex);
			} catch(std::exception const& ex) {
				accessToken = tstring(ex.what(), ex.what() + strlen(ex.what()));
				PostMessage(dialog, WM_SET_TOKEN, 0, 0);
			}
		};
		return Callback(std::move(task), onSuccess, onFailure);
	}

	decltype(StartAuthImpl(HWND())) callback;

	void StartAuth(HWND dialog) {
		callback = std::move(StartAuthImpl(dialog));
	}

	BOOL OnInitDialog(HWND dialog, HWND /*focusWindow*/, LPARAM /*lParam*/) {
		SetDlgItemText(dialog, IDC_CLIENT_ID, _T("dviaxdls39mj44cdnei76mj2dlig33"));
		SetDlgItemText(dialog, IDC_REDIRECT_URI, _T("gsdk://twitch.tv/auth"));
		SetDlgItemText(dialog, IDC_SCOPES, defaultScopes);
		return TRUE;
	}

	void OnCommand(HWND dialog, int id, HWND /*controlWindow*/, UINT /*notificationCode*/) {
		if(id == IDOK) {
			StartAuth(dialog);
		} else if(id == IDCANCEL) {
			auth.Cancel();
			EndDialog(dialog, id);
		}
	}
}

INT_PTR CALLBACK ClientAuthDialog(HWND dialog, UINT message, WPARAM wParam, LPARAM lParam) {
	switch(message) {
		HANDLE_MSG(dialog, WM_INITDIALOG, OnInitDialog);
		HANDLE_MSG(dialog, WM_COMMAND, OnCommand);
	case WM_SET_TOKEN:
		SetDlgItemText(dialog, IDC_ACCESS_TOKEN, accessToken.c_str());
		Button_Enable(GetDlgItem(dialog, IDOK), TRUE);
		return TRUE;
	}
	return FALSE;
}
