#include "stdafx.h"
#include "resource.h"
#include "ClipsDialog.h"

using namespace Twitch;

extern tstring accessToken, clientId;

namespace {
	Clip clip;

	void CreateClip(HWND dialog) {
		TCHAR clientId_[99];
		GetDlgItemText(dialog, IDC_CLIENT_ID, clientId_, _countof(clientId_));
		TCHAR accessToken_[99];
		GetDlgItemText(dialog, IDC_ACCESS_TOKEN, accessToken_, _countof(accessToken_));
		TCHAR broadcasterId[99];
		GetDlgItemText(dialog, IDC_BROADCASTER_ID, broadcasterId, _countof(broadcasterId));
		bool hasDelay = Button_GetCheck(GetDlgItem(dialog, IDC_HAS_DELAY)) == BST_CHECKED;
		try {
			auto clipId = Clip::Create(clientId_, accessToken_, broadcasterId, hasDelay).get();
			SetDlgItemText(dialog, IDC_CLIP_ID, clipId.c_str());
		} catch(std::exception const& ex) {
			SetDlgItemTextA(dialog, IDC_CLIP_ID, ex.what());
		}
	}

	void FetchClip(HWND dialog) {
		TCHAR clientId_[99];
		GetDlgItemText(dialog, IDC_CLIENT_ID, clientId_, _countof(clientId_));
		TCHAR clipId[99];
		GetDlgItemText(dialog, IDC_CLIP_ID, clipId, _countof(clipId));
		clip = Clip::Fetch(clientId_, clipId).get();
		SetDlgItemText(dialog, IDC_URL, clip.Url.c_str());
		SetDlgItemText(dialog, IDC_BROADCASTER_LOGIN, clip.BroadcasterLogin.c_str());
		SetDlgItemText(dialog, IDC_CREATOR_ID, clip.CreatorId.c_str());
		SetDlgItemText(dialog, IDC_CREATOR_LOGIN, clip.CreatorLogin.c_str());
		SetDlgItemText(dialog, IDC_VIDEO_ID, clip.VideoId.c_str());
		SetDlgItemText(dialog, IDC_GAME_ID, clip.GameId.c_str());
		SetDlgItemText(dialog, IDC_LANGUAGE, clip.Language.c_str());
		SetDlgItemText(dialog, IDC_TITLE, clip.Title.c_str());
		SetDlgItemInt(dialog, IDC_VIEW_COUNT, clip.ViewCount, FALSE);
		SetDlgItemText(dialog, IDC_CREATED_AT, clip.CreatedAt.c_str());
		SetDlgItemText(dialog, IDC_THUMBNAIL_URL, clip.ThumbnailUrl.c_str());
	}

	BOOL OnInitDialog(HWND dialog, HWND /*focusWindow*/, LPARAM /*lParam*/) {
		SetDlgItemText(dialog, IDC_CLIENT_ID, clientId.c_str());
		SetDlgItemText(dialog, IDC_ACCESS_TOKEN, accessToken.c_str());
		return TRUE;
	}

	void OnCommand(HWND dialog, int id, HWND /*controlWindow*/, UINT /*notificationCode*/) {
		if(id == IDOK) {
			CreateClip(dialog);
		} else if(id == IDC_FETCH) {
			FetchClip(dialog);
		} else if(id == IDCANCEL) {
			EndDialog(dialog, id);
		}
	}
}

INT_PTR CALLBACK ClipsDialog(HWND dialog, UINT message, WPARAM wParam, LPARAM lParam) {
	switch(message) {
		HANDLE_MSG(dialog, WM_INITDIALOG, OnInitDialog);
		HANDLE_MSG(dialog, WM_COMMAND, OnCommand);
	}
	return FALSE;
}
