#pragma once

#include "Renderer.h"
#include "DeviceResources.h"
#include "StepTimer.h"

namespace nativeplayer {

class DebugRenderer : public Renderer {
public:
    DebugRenderer(const std::shared_ptr<DX::DeviceResources> &deviceResources, Application& application);
    ~DebugRenderer() override = default;

    void CreateDeviceDependentResources() override;
    void ReleaseDeviceDependentResources() override;

    void Update(DX::StepTimer const &timer) override;
    void Render() override;

private:
    Application& application;

    // Resources related to text rendering.
    std::wstring                                 text;
    DWRITE_TEXT_METRICS                          textMetrics;
    Microsoft::WRL::ComPtr<ID2D1SolidColorBrush> whiteBrush;
    Microsoft::WRL::ComPtr<ID2D1SolidColorBrush> background;
    Microsoft::WRL::ComPtr<IDWriteTextLayout1>   textLayout;
    Microsoft::WRL::ComPtr<IDWriteTextFormat>    textFormat;
};
}
