#pragma once

#include "DeviceResources.h"
#include "StepTimer.h"

namespace nativeplayer {

class Renderer {
public:
    Renderer(const std::shared_ptr<DX::DeviceResources> &deviceResources);
    virtual ~Renderer() = default;

    virtual void CreateDeviceDependentResources() = 0;
    virtual void CreateWindowSizeDependentResources();
    virtual void ReleaseDeviceDependentResources() = 0;

    virtual void Update(DX::StepTimer const &timer) = 0;
    virtual void Render() = 0;
 
    virtual bool IsInWindow(Windows::Foundation::Point point);
    virtual void OnPointerPressed(Windows::Foundation::Point point);
    virtual void OnPointerReleased(Windows::Foundation::Point point);

protected:
    std::wstring stringtowstring(const std::string& input);

protected:
    std::shared_ptr<DX::DeviceResources> deviceResources;
    Microsoft::WRL::ComPtr<ID2D1DrawingStateBlock1> stateBlock;
};

}
