#pragma once

#include "DeviceResources.h"
#include "StepTimer.h"
#include "TextureAndSRVNV12.hpp"
#include "TextureMapper.hpp"
#include "Renderer.h"
#include "ShaderStructures.h"

namespace nativeplayer {

// This sample renderer instantiates a basic rendering pipeline.
class Sample3DSceneRenderer : public Renderer {
public:
    Sample3DSceneRenderer(const std::shared_ptr<DX::DeviceResources> &deviceResources, Application& application);
    ~Sample3DSceneRenderer() override;

    void CreateDeviceDependentResources() override;
    void CreateWindowSizeDependentResources() override;
    void ReleaseDeviceDependentResources() override;

    void Update(DX::StepTimer const &timer) override;
    void Render() override;

    void StartTracking();
    void TrackingUpdate(Windows::Foundation::Point position);
    void StopTracking();
    bool IsTracking() { return tracking; }

    static const UINT DefaultTextureWidth = 1920;
    static const UINT DefaultTextureHeight = 1088;
private:
    void SetOnRenderCallback();
    void UpdateTexture();
private:
    Application& application;
    HRESULT hr;

    // Direct3D resources for cube geometry.
    Microsoft::WRL::ComPtr<ID3D11InputLayout>   inputLayout;
    Microsoft::WRL::ComPtr<ID3D11Buffer>        vertexBuffer;
    Microsoft::WRL::ComPtr<ID3D11Buffer>        indexBuffer;
    Microsoft::WRL::ComPtr<ID3D11VertexShader>  vertexShader;
    Microsoft::WRL::ComPtr<ID3D11PixelShader>   pixelShader;
    Microsoft::WRL::ComPtr<ID3D11Buffer>        constantBuffer;

    // Texture stuff
    std::shared_ptr<TextureMapper> textureMapper;

    // System resources for cube geometry.
    ModelViewProjectionConstantBuffer   constantBufferData;
    uint32  indexCount;

    // Variables used with the rendering loop.
    bool    firstUpdateDone = false;
    bool    textureUpdated = false;
    bool    loadingComplete;
    bool    tracking;

    struct ImageInfo
    {
        Microsoft::WRL::ComPtr<ID3D11Texture2D> imageTexture;
        int imageWidth = 0;
        int imageHeight = 0;
    };

    std::mutex imageMutex;
    ImageInfo image;

};
}

