Texture2D<float> shaderTextureY;
Texture2D<float2> shaderTextureUV;
SamplerState SampleType;

struct PS_INPUT {
    float4 Position : SV_POSITION;
    float2 Texture : TEXCOORD0;
};

float4 main(PS_INPUT In)
    : SV_TARGET
{
    float Y = shaderTextureY.Sample(SampleType, In.Texture);

    float2 UV = shaderTextureUV.Sample(SampleType, In.Texture);
    float U = UV.x;
    float V = UV.y; 

    Y = Y * 255;
    U = U * 255;
    V = V * 255;

    float R = Y + (1.370705 * (V - 128));
    float G = Y - (0.698001 * (V - 128)) - (0.337633 * (U - 128));
    float B = Y + (1.732446 * (U - 128));
    float A = 255; // opaque

    return float4(R/255, G/255, B/255, A/255);
}
