#include "stdafx.h"
#include <WS2tcpip.h>
#include "resource.h"
#include "ServerAuthDialog.h"

using namespace Twitch;

extern tstring accessToken, refreshToken, clientId;

namespace {
	tstring accessToken_, refreshToken_, state;
	std::future<void> task;
	TCHAR clientId_[99];
	constexpr UINT WM_SET_STATE = WM_USER + 111;
	constexpr UINT WM_SET_TOKENS = WM_SET_STATE + 1;

	void StartAuth(HWND dialog) {
		TCHAR redirectUri[99], scopes[99];
		GetDlgItemText(dialog, IDC_CLIENT_ID, clientId_, _countof(clientId_));
		GetDlgItemText(dialog, IDC_REDIRECT_URI, redirectUri, _countof(redirectUri));
		GetDlgItemText(dialog, IDC_SCOPES, scopes, _countof(scopes));
		auto fn = [dialog, redirectUri = tstring(redirectUri), scopes = tstring(scopes)]{
			// Communicate with the "server" to complete the flow.
			WSADATA wsaData;
			WSAStartup(MAKEWORD(2, 2), &wsaData);

			// Create a client socket.
			auto clientSocket = socket(AF_INET, SOCK_STREAM, IPPROTO_IP);
			if(clientSocket != INVALID_SOCKET) {
				// Connect to the "server".
				sockaddr_in sa{};
				InetPton(AF_INET, _T("127.0.0.1"), &sa.sin_addr);
				sa.sin_family = AF_INET;
				sa.sin_port = htons(50537);
				if(connect(clientSocket, reinterpret_cast<sockaddr*>(&sa), sizeof(sa)) != SOCKET_ERROR) {
					// Start the server authentication flow.
					ServerAuth serverAuth;
					auto task_ = serverAuth.StartAuth(clientId_, redirectUri, scopes, state);
					PostMessage(dialog, WM_SET_STATE, 0, 0);

					// Send the state to the "server".  It will use it to
					// validate the Twitch server authentication response.
					send(clientSocket, reinterpret_cast<char const*>(state.data()),
						static_cast<int>(state.size() * sizeof(state[0])), 0);
					shutdown(clientSocket, SD_SEND);

					// Receive the access and refresh tokens from the "server".
					char buffer[888];
					auto n = recv(clientSocket, buffer, sizeof(buffer), 0);
					if(n < 0) {
						accessToken_ = _T("Cannot receive");
					} else {
						tstring s(buffer, buffer + n / sizeof(buffer[0]));
						auto i = s.find(_T('\t'));
						if(i == s.npos) {
							accessToken_ = _T("No token");
						} else {
							accessToken_ = tstring(s.cbegin(), s.cbegin() + i);
							refreshToken_ = tstring(s.cbegin() + i + 1, s.cend());
						}

						// Complete the server authentication by setting the tokens.
						serverAuth.Finish(accessToken_, refreshToken_);
						task_.wait();
					}
				} else {
					accessToken_ = _T("Cannot connect");
				}
				closesocket(clientSocket);
			}
			PostMessage(dialog, WM_SET_TOKENS, 0, 0);
		};
		task = std::async(std::launch::async, fn);
	}

	BOOL OnInitDialog(HWND dialog, HWND /*focusWindow*/, LPARAM /*lParam*/) {
		SetDlgItemText(dialog, IDC_CLIENT_ID, _T("mb1glzpzrvzalxvztn1epbtxralpsb"));
		SetDlgItemText(dialog, IDC_REDIRECT_URI, _T("http://localhost:27077/auth"));
		SetDlgItemText(dialog, IDC_SCOPES, defaultScopes);
		return TRUE;
	}

	void OnCommand(HWND dialog, int id, HWND /*controlWindow*/, UINT /*notificationCode*/) {
		if(id == IDOK) {
			StartAuth(dialog);
		} else if(id == IDCANCEL) {
			if(!accessToken_.empty()) {
				accessToken = accessToken_;
				refreshToken = refreshToken_;
				clientId = clientId_;
			}
			EndDialog(dialog, id);
		}
	}
}

INT_PTR CALLBACK ServerAuthDialog(HWND dialog, UINT message, WPARAM wParam, LPARAM lParam) {
	switch(message) {
		HANDLE_MSG(dialog, WM_INITDIALOG, OnInitDialog);
		HANDLE_MSG(dialog, WM_COMMAND, OnCommand);
	case WM_SET_STATE:
		SetDlgItemText(dialog, IDC_STATE, state.c_str());
		return TRUE;
	case WM_SET_TOKENS:
		SetDlgItemText(dialog, IDC_ACCESS_TOKEN, accessToken_.c_str());
		SetDlgItemText(dialog, IDC_REFRESH_TOKEN, refreshToken_.c_str());
		return TRUE;
	}
	return FALSE;
}
