#include "stdafx.h"
#include "resource.h"
#include "StreamsDialog.h"

using namespace Twitch;

extern tstring clientId;

namespace {
	constexpr string_t streamTypes[] = { _T("None"), _T("Live"), _T("Vodcast") };
	std::vector<Stream> streams;
	int streamIndex;

	void DisplayStream(HWND dialog) {
		auto const& stream = streams[streamIndex];
		if(!stream.CommunityIds.empty()) {
			SetDlgItemText(dialog, IDC_RESPONSE_COMMUNITY_IDS, stream.CommunityIds[0].c_str());
		}
		SetDlgItemText(dialog, IDC_RESPONSE_GAME_ID, stream.GameId.c_str());
		SetDlgItemText(dialog, IDC_RESPONSE_STREAM_ID, stream.Id.c_str());
		SetDlgItemText(dialog, IDC_RESPONSE_LANGUAGE, stream.Language.c_str());
		SetDlgItemText(dialog, IDC_RESPONSE_STARTED_AT, ConstructTimeString(stream.StartedAt).c_str());
		SetDlgItemText(dialog, IDC_RESPONSE_THUMBNAIL_URL, stream.ThumbnailUrl.c_str());
		SetDlgItemText(dialog, IDC_RESPONSE_TITLE, stream.Title.c_str());
		SetDlgItemText(dialog, IDC_RESPONSE_TYPE, streamTypes[static_cast<int>(stream.Type)]);
		SetDlgItemText(dialog, IDC_RESPONSE_USER_ID, stream.UserId.c_str());
		SetDlgItemText(dialog, IDC_RESPONSE_USER_LOGIN, stream.UserLogin.c_str());
		SetDlgItemInt(dialog, IDC_RESPONSE_VIEWER_COUNT, stream.ViewerCount, FALSE);
		EnableWindow(GetDlgItem(dialog, IDC_NEXT), streamIndex + 1 < streams.size());
		EnableWindow(GetDlgItem(dialog, IDC_PREVIOUS), streamIndex > 0);
	}

	void FetchStreams(HWND dialog) {
		TCHAR clientId_[99], count[99], communityId[99], gameId[99], language[99], userId[99], userLogin[99];
		GetDlgItemText(dialog, IDC_CLIENT_ID, clientId_, _countof(clientId_));
		if(!clientId_[0]) {
			return;
		}
		GetDlgItemText(dialog, IDC_REQUEST_COUNT, count, _countof(count));
		GetDlgItemText(dialog, IDC_REQUEST_COMMUNITY_IDS, communityId, _countof(communityId));
		GetDlgItemText(dialog, IDC_REQUEST_GAME_IDS, gameId, _countof(gameId));
		GetDlgItemText(dialog, IDC_REQUEST_LANGUAGE, language, _countof(language));
		GetDlgItemText(dialog, IDC_REQUEST_USER_ID, userId, _countof(userId));
		GetDlgItemText(dialog, IDC_REQUEST_USER_LOGIN, userLogin, _countof(userLogin));
		StreamsRequest request;
		request.Count = _ttoi(count);
		request.CommunityId = communityId;
		request.GameId = gameId;
		request.Language = language;
		request.UserId = userId;
		request.UserLogin = userLogin;
		auto response = request.Fetch(clientId_).get();
		if(!response.Streams.empty()) {
			streams = response.Streams;
			streamIndex = 0;
			DisplayStream(dialog);
		}
	}

	BOOL OnInitDialog(HWND dialog, HWND /*focusWindow*/, LPARAM /*lParam*/) {
		SetDlgItemText(dialog, IDC_CLIENT_ID, clientId.c_str());
		return TRUE;
	}

	void OnCommand(HWND dialog, int id, HWND /*controlWindow*/, UINT /*notificationCode*/) {
		if(id == IDOK) {
			FetchStreams(dialog);
		} else if(id == IDCANCEL) {
			EndDialog(dialog, id);
		} else if(id == IDC_NEXT) {
			++streamIndex;
			DisplayStream(dialog);
		} else if(id == IDC_PREVIOUS) {
			--streamIndex;
			DisplayStream(dialog);
		}
	}
}

INT_PTR CALLBACK StreamsDialog(HWND dialog, UINT message, WPARAM wParam, LPARAM lParam) {
	switch(message) {
		HANDLE_MSG(dialog, WM_INITDIALOG, OnInitDialog);
		HANDLE_MSG(dialog, WM_COMMAND, OnCommand);
	}
	return FALSE;
}
