#pragma once

#include "DeviceResources.h"

// Wrapper over Texture and SRV resources needed
class TextureAndSRVNV12 {
public:
    TextureAndSRVNV12(std::shared_ptr<DX::DeviceResources> deviceResources, int width, int height);
    ~TextureAndSRVNV12();

    void Reset();
    void Update(Microsoft::WRL::ComPtr<ID3D11Texture2D> texture);

    Microsoft::WRL::ComPtr<ID3D11Texture2D> getTexture() const;
    Microsoft::WRL::ComPtr<ID3D11ShaderResourceView> getSRV(int index) const;
    Microsoft::WRL::ComPtr<ID3D11SamplerState> getSamplerState() const;

private:
    const std::shared_ptr<DX::DeviceResources> deviceResources;
    const int m_width;
    const int m_height;
    HRESULT m_hr;

    Microsoft::WRL::ComPtr<ID3D11Texture2D> m_texture;
    Microsoft::WRL::ComPtr<ID3D11ShaderResourceView> m_shaderResourceView[2];
    Microsoft::WRL::ComPtr<ID3D11SamplerState> m_samplerState;
};
