#pragma once

#include <string>
#include "Renderer.h"
#include "DeviceResources.h"
#include "StepTimer.h"

namespace nativeplayer {

class TimelineRenderer : public Renderer {
public:
    TimelineRenderer(const std::shared_ptr<DX::DeviceResources> &deviceResources, Application& application);
    ~TimelineRenderer() override = default;

    void CreateDeviceDependentResources() override;
    void ReleaseDeviceDependentResources() override;
    
    void Update(DX::StepTimer const &timer) override;
    void Render() override;

    bool IsInWindow(Windows::Foundation::Point point) override;
    void OnPointerPressed(Windows::Foundation::Point point) override;
    void OnPointerReleased(Windows::Foundation::Point point) override;
private:
    static const unsigned int TIMELINE_STEP_COUNT = 11;
    const float TIME_STEP_WIDTH = 200.0f;
    const float TIME_STEP_HEIGHT = 25.0f;

    Application& application;

    Microsoft::WRL::ComPtr<ID2D1SolidColorBrush>    alphaBrush;
    Microsoft::WRL::ComPtr<ID2D1SolidColorBrush>    whiteBrush;
    Microsoft::WRL::ComPtr<ID2D1SolidColorBrush>    background;
    Microsoft::WRL::ComPtr<ID2D1SolidColorBrush>    yellowBrush;
    
    std::wstring                                    text[TIMELINE_STEP_COUNT];
    Microsoft::WRL::ComPtr<IDWriteTextLayout1>      textLayout[TIMELINE_STEP_COUNT];
    Microsoft::WRL::ComPtr<IDWriteTextFormat>       textFormat;

    D2D1_RECT_F bounds;
};
}
