#include "stdafx.h"
#include "resource.h"
#include "FollowersDialog.h"
#include "UserDialog.h"

using namespace Twitch;

extern tstring accessToken, clientId;

namespace {
	void FetchUser(HWND dialog) {
		TCHAR clientId_[99];
		GetDlgItemText(dialog, IDC_CLIENT_ID, clientId_, _countof(clientId_));
		if(!clientId_[0]) {
			return;
		}
		User user;
		TCHAR sz[99];
		if(Button_GetCheck(GetDlgItem(dialog, IDC_BY_TOKEN)) == BST_CHECKED) {
			GetDlgItemText(dialog, IDC_ACCESS_TOKEN, sz, _countof(sz));
			if(!sz[0]) {
				return;
			}
			user = User::FetchCurrent(clientId_, sz).get();
			accessToken = sz;
		} else if(Button_GetCheck(GetDlgItem(dialog, IDC_BY_ID)) == BST_CHECKED) {
			GetDlgItemText(dialog, IDC_ID, sz, _countof(sz));
			if(!sz[0]) {
				return;
			}
			user = User::FetchOtherById(clientId_, sz).get();
		} else if(Button_GetCheck(GetDlgItem(dialog, IDC_BY_LOGIN)) == BST_CHECKED) {
			GetDlgItemText(dialog, IDC_LOGIN, sz, _countof(sz));
			if(!sz[0]) {
				return;
			}
			user = User::FetchOtherByLogin(clientId_, sz).get();
		}
		clientId = clientId_;
		SetDlgItemText(dialog, IDC_ID, user.Id.c_str());
		SetDlgItemText(dialog, IDC_LOGIN, user.Login.c_str());
		SetDlgItemText(dialog, IDC_DISPLAY_NAME, user.DisplayName.c_str());
		SetDlgItemText(dialog, IDC_EMAIL, user.Email.c_str());
		SetDlgItemText(dialog, IDC_TYPE, user.Type.c_str());
		SetDlgItemText(dialog, IDC_BROADCASTER_TYPE, user.BroadcasterType.c_str());
		SetDlgItemText(dialog, IDC_OFFLINE_IMAGE_URL, user.OfflineImageUrl.c_str());
		SetDlgItemText(dialog, IDC_PROFILE_IMAGE_URL, user.ProfileImageUrl.c_str());
		SetDlgItemInt(dialog, IDC_VIEW_COUNT, user.ViewCount, FALSE);
		SetDlgItemText(dialog, IDC_DESCRIPTION, user.Description.c_str());
		EnableWindow(GetDlgItem(dialog, IDC_FETCH_FOLLOWERS), !accessToken.empty());
	}

	void FetchFollowers(HWND dialog) {
		TCHAR sz[99];
		GetDlgItemText(dialog, IDC_ID, sz, _countof(sz));
		if(!sz[0]) {
			return;
		}
		auto followersRequest = FollowersRequest();
		auto followers = followersRequest.Fetch(clientId, accessToken, sz).get();
		userIds.clear();
		timestamps.clear();
		for(auto const& follower : followers.Followers) {
			userIds += follower.UserId;
			userIds += _T("\r\n");
			timestamps += ConstructTimeString(follower.FollowedAt);
			timestamps += _T("\r\n");
		}
		DialogBox(GetModuleHandle(nullptr), MAKEINTRESOURCE(IDD_FOLLOWERS_DIALOG), dialog, FollowersDialog);
	}

	BOOL OnInitDialog(HWND dialog, HWND /*focusWindow*/, LPARAM /*lParam*/) {
		SetDlgItemText(dialog, IDC_CLIENT_ID, clientId.c_str());
		if(accessToken.empty()) {
			EnableWindow(GetDlgItem(dialog, IDC_ACCESS_TOKEN), FALSE);
			CheckDlgButton(dialog, IDC_BY_ID, BST_CHECKED);
			EnableWindow(GetDlgItem(dialog, IDC_LOGIN), FALSE);
		} else {
			CheckDlgButton(dialog, IDC_BY_TOKEN, BST_CHECKED);
			SetDlgItemText(dialog, IDC_ACCESS_TOKEN, accessToken.c_str());
			EnableWindow(GetDlgItem(dialog, IDC_ID), FALSE);
			EnableWindow(GetDlgItem(dialog, IDC_LOGIN), FALSE);
		}
		return TRUE;
	}

	void OnCommand(HWND dialog, int id, HWND /*controlWindow*/, UINT notificationCode) {
		if(id == IDOK) {
			FetchUser(dialog);
		} else if(id == IDCANCEL) {
			EndDialog(dialog, id);
		} else if(id == IDC_BY_TOKEN || id == IDC_BY_ID || id == IDC_BY_LOGIN) {
			if(notificationCode == BN_CLICKED) {
				EnableWindow(GetDlgItem(dialog, IDC_ACCESS_TOKEN), id == IDC_BY_TOKEN);
				EnableWindow(GetDlgItem(dialog, IDC_ID), id == IDC_BY_ID);
				EnableWindow(GetDlgItem(dialog, IDC_LOGIN), id == IDC_BY_LOGIN);
			}
		} else if(id == IDC_FETCH_FOLLOWERS) {
			FetchFollowers(dialog);
		}
	}
}

INT_PTR CALLBACK UserDialog(HWND dialog, UINT message, WPARAM wParam, LPARAM lParam) {
	switch(message) {
		HANDLE_MSG(dialog, WM_INITDIALOG, OnInitDialog);
		HANDLE_MSG(dialog, WM_COMMAND, OnCommand);
	}
	return FALSE;
}
