#include "stdafx.h"
#include "WindowsExample.h"
#include "ClientAuthDialog.h"
#include "ServerAuthDialog.h"
#include "UserDialog.h"
#include "StreamsDialog.h"
#include "ClipsDialog.h"

using namespace Windows::Foundation;
using namespace nativeplayer;

Twitch::tstring accessToken, refreshToken, clientId = _T("aa979eepgt7t1fcrqowhfbcyyb8biz");

static App* app;

static BOOL InitInstance(HINSTANCE, int);
static LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
static INT_PTR CALLBACK About(HWND, UINT, WPARAM, LPARAM);

int APIENTRY wWinMain(_In_ HINSTANCE hInstance, _In_opt_ HINSTANCE /*hPrevInstance*/, _In_ LPWSTR /*lpCmdLine*/, _In_ int nCmdShow) {
	// Initialize COM.
	if(FAILED(CoInitializeEx(NULL, COINIT_MULTITHREADED))) {
		return 1;
	}

	// Perform application initialization.
	App app_;
	app = &app_;
	app_.Initialize();
	if(!InitInstance(hInstance, nCmdShow)) {
		return 1;
	}

	app_.Run();

	return 0;
}

App::App() {}

void App::Initialize() {
	// At this point we have access to the device.
	// We can create the device-dependent resources.
	deviceResources = std::make_shared<DX::DeviceResources>();
	m_application.Initialize(deviceResources->GetDevice());
}

void App::SetWindow(HWND window) {
	deviceResources->SetWindow(window);
}

// Initialize scene resources.
void App::Load() {
	m_main = std::make_unique<nativeplayerMain>(deviceResources, m_application);
}

// This method is called after the window becomes active.
void App::Run() {
	HACCEL const hAccelTable = LoadAccelerators(GetModuleHandle(nullptr), MAKEINTRESOURCE(IDC_WINDOWSEXAMPLE));
	MSG msg;
	for(bool isIdle; isIdle = !PeekMessage(&msg, nullptr, 0u, 0u, PM_REMOVE), msg.message != WM_QUIT;) {
		if(isIdle) {
			m_application.Update();
			m_main->Update();

			if(m_main->Render()) {
				deviceResources->Present();
			}
		} else {
			if(!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) {
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
	}
}

// Window event handlers.

void App::OnWindowSizeChanged(HWND /*sender*/, UINT /*state*/, int cx, int cy) {
	deviceResources->SetLogicalSize(Size{ static_cast<float>(cx), static_cast<float>(cy) });
	m_main->CreateWindowSizeDependentResources();
}

void App::OnPointerPressed(HWND /*sender*/, BOOL /*fDoubleClick*/, int x, int y, UINT /*keyFlags*/) {
	// When the pointer is pressed begin tracking the pointer movement.
	m_main->StartTracking();
	m_main->TrackingUpdate(Point());
	m_pointerStartPosition = Point{ x, y };

	m_main->OnPointerPressed(m_pointerStartPosition);
}

void App::OnPointerMoved(HWND /*sender*/, int x, int y, UINT /*keyFlags*/) {
	// Update the pointer tracking code.
	if(m_main->IsTracking()) {
		Point diff;
		diff.x = x - m_pointerStartPosition.x;
		diff.y = y - m_pointerStartPosition.y;
		m_main->TrackingUpdate(diff);
	}
}

void App::OnPointerReleased(HWND /*sender*/, int x, int y, UINT /*keyFlags*/) {
	// Stop tracking pointer movement when the pointer is released.
	m_main->StopTracking();

	m_main->OnPointerReleased(Point{ x, y });
}

void App::OnKeyUp(HWND /*sender*/, UINT vk, BOOL /*fDown*/, int /*cRepeat*/, UINT /*flags*/) {
	switch(vk) {
	case 'A':
		m_application.Play();
		break;
	case 'X':
		m_application.Pause();
		break;
	case 'Y':
		m_application.SelectPreviousVideo();
		break;
	case 'B':
		m_application.SelectNextVideo();
		break;
	case VK_UP:
		m_application.SeekBackward30Seconds();
		break;
	case VK_DOWN:
		m_application.SeekForward30Seconds();
		break;
	case VK_LEFT:
		m_application.SeekBackward5Seconds();
		break;
	case VK_RIGHT:
		m_application.SeekForward5Seconds();
		break;
	}
}

static BOOL InitInstance(HINSTANCE hInstance, int nCmdShow) {
	// Initialize the common controls.
	INITCOMMONCONTROLSEX icc{ sizeof(INITCOMMONCONTROLSEX), ICC_STANDARD_CLASSES | ICC_LINK_CLASS };
	if(!InitCommonControlsEx(&icc)) {
		return FALSE;
	}

	// Register the window class.
	WNDCLASSEX wcex;
	wcex.cbSize = sizeof(WNDCLASSEX);
	wcex.style = CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc = WndProc;
	wcex.cbClsExtra = 0;
	wcex.cbWndExtra = 0;
	wcex.hInstance = hInstance;
	wcex.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_WINDOWSEXAMPLE));
	wcex.hCursor = LoadCursor(nullptr, IDC_ARROW);
	wcex.hbrBackground = reinterpret_cast<HBRUSH>(COLOR_WINDOW + 1);
	wcex.lpszMenuName = MAKEINTRESOURCEW(IDC_WINDOWSEXAMPLE);
	wcex.lpszClassName = _T("NativePlayerWindowClassName");
	wcex.hIconSm = wcex.hIcon;
	RegisterClassEx(&wcex);

	// Create the window.
	LPCTSTR title = _T("NativePlayer");
	HWND const hWnd = CreateWindow(wcex.lpszClassName, title, WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, nullptr, nullptr, hInstance, nullptr);

	if(!hWnd) {
		return FALSE;
	}

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	return TRUE;
}

static bool OnCreate(HWND hwnd, LPCREATESTRUCT /*lpCreateStruct*/) {
	app->SetWindow(hwnd);
	app->Load();
	return true;
}

static void OnCommand(HWND hwnd, int id, HWND /*hwndCtl*/, UINT /*codeNotify*/) {
	// Parse the menu selections.
	switch(id) {
	case ID_FILE_CLIENTAUTH:
		DialogBox(GetModuleHandle(nullptr), MAKEINTRESOURCE(IDD_CLIENT_AUTH_DIALOG), hwnd, ClientAuthDialog);
		break;
	case ID_FILE_SERVERAUTH:
		DialogBox(GetModuleHandle(nullptr), MAKEINTRESOURCE(IDD_SERVER_AUTH_DIALOG), hwnd, ServerAuthDialog);
		break;
	case ID_FILE_USER:
		DialogBox(GetModuleHandle(nullptr), MAKEINTRESOURCE(IDD_USER_DIALOG), hwnd, UserDialog);
		break;
	case ID_FILE_STREAMS:
		DialogBox(GetModuleHandle(nullptr), MAKEINTRESOURCE(IDD_STREAMS_DIALOG), hwnd, StreamsDialog);
		break;
	case ID_FILE_CLIPS:
		DialogBox(GetModuleHandle(nullptr), MAKEINTRESOURCE(IDD_CLIPS_DIALOG), hwnd, ClipsDialog);
		break;
	case IDM_ABOUT:
		DialogBox(GetModuleHandle(nullptr), MAKEINTRESOURCE(IDD_ABOUTBOX), hwnd, About);
		break;
	case IDM_EXIT:
		DestroyWindow(hwnd);
		break;
	}
}

static LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
	switch(message) {
		HANDLE_MSG(hWnd, WM_CREATE, OnCreate);
		HANDLE_MSG(hWnd, WM_COMMAND, OnCommand);
		HANDLE_MSG(hWnd, WM_KEYUP, app->OnKeyUp);
		HANDLE_MSG(hWnd, WM_LBUTTONDOWN, app->OnPointerPressed);
		HANDLE_MSG(hWnd, WM_LBUTTONUP, app->OnPointerReleased);
		HANDLE_MSG(hWnd, WM_MOUSEMOVE, app->OnPointerMoved);
		HANDLE_MSG(hWnd, WM_SIZE, app->OnWindowSizeChanged);
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

// message handler for about box
static INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM /*lParam*/) {
	switch(message) {
	case WM_INITDIALOG:
		return TRUE;
	case WM_COMMAND:
		if(LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) {
			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		break;
	}
	return FALSE;
}
