#pragma once

#include "nativeplayer.hpp"
#include "DeviceResources.h"
#include "nativeplayerMain.h"
#include "resource.h"

namespace nativeplayer {
// Main entry point for our app. Connects the app with the Windows shell and handles application lifecycle events.
class App {
public:
    App();

    virtual void Initialize();
    virtual void SetWindow(HWND window);
    virtual void Load();
    virtual void Run();

    // Window event handlers.
    void OnWindowSizeChanged(HWND sender, UINT state, int cx, int cy);

    // Mouse tracking
    void OnPointerPressed(HWND sender, BOOL fDoubleClick, int x, int y, UINT keyFlags);
    void OnPointerMoved(HWND sender, int x, int y, UINT keyFlags);
    void OnPointerReleased(HWND sender, int x, int y, UINT keyFlags);

    // Keyboard/Gamepad
    void OnKeyUp(HWND sender, UINT vk, BOOL fDown, int cRepeat, UINT flags);

private:
    std::shared_ptr<DX::DeviceResources> deviceResources;
    std::unique_ptr<nativeplayerMain> m_main;

    Windows::Foundation::Point m_pointerStartPosition;

    Application m_application;
};
}
