#pragma once

#include <Twitch.h>

class ApplicationBase {
public:
	virtual int Initialize(Microsoft::WRL::ComPtr<ID3D11Device1> device) = 0;
	virtual int Update() = 0;
	virtual void Render() = 0;
	virtual int Finalize() = 0;

	using RenderCallback = Twitch::Player::RenderFn;
	RenderCallback OnRenderCallback;

protected:
private:
};

class Application : public ApplicationBase, public Twitch::Player::Observer {
public:
	int Initialize(Microsoft::WRL::ComPtr<ID3D11Device1> device) override;
	int Update() override;
	void Render() override;
	int Finalize() override;

	const std::shared_ptr<Twitch::Player> getMediaPlayer() const { return m_player; }
	std::shared_ptr<Twitch::Player> getMediaPlayer() { return m_player; }

	void SelectNextVideo();
	void SelectPreviousVideo();
	void Play();
	void Pause();
	void SeekForward5Seconds();
	void SeekForward30Seconds();
	void SeekBackward5Seconds();
	void SeekBackward30Seconds();

private:
	using PlayerState = Twitch::Player::PlayerState;

	void HandleStartSeek();

	void OnDurationChanged(double /*duration*/) override {};
	void OnError(Twitch::tstring const& /*message*/) override;
	void OnRebuffering() override {};
	void OnSeekCompleted(double /*time*/) override {};
	void OnStateChanged(PlayerState /*state*/) override;
	void OnPositionChanged(double /*position*/) override {};

	std::shared_ptr<Twitch::Player> m_player;

	Twitch::tstring lastError;

	// next option to be added, a state machine class will be created. :)
	PlayerState m_playerState = PlayerState::Idle;
	bool m_playerStarted = false;
	bool m_initialSeek = false;

	int m_currentFrameCounter = 0;
	int m_currentVideoIndex = 0;
};
