#pragma once

#include "StepTimer.h"
#include "DeviceResources.h"
#include "Sample3DSceneRenderer.h"

// Renders Direct3D content on the screen.
namespace nativeplayer {
	class nativeplayerMain : public DX::IDeviceNotify {
	public:
		nativeplayerMain(std::shared_ptr<DX::DeviceResources> const& deviceResources, Application& application);
		~nativeplayerMain();
		void CreateWindowSizeDependentResources();
		void Update();
		bool Render();

		// IDeviceNotify
		virtual void OnDeviceLost();
		virtual void OnDeviceRestored();

		// Pointer tracking
		void StartTracking() { m_sceneRenderer->StartTracking(); }
		void TrackingUpdate(POINT position) { m_pointerLocation = position; }
		void StopTracking() { m_sceneRenderer->StopTracking(); }
		bool IsTracking() { return m_sceneRenderer->IsTracking(); }

		void OnPointerPressed(POINT point);
		void OnPointerReleased(POINT point);
	private:
		void ProcessInput();

		std::list<std::shared_ptr<Renderer>> m_renderers;

		// Cached pointer to device resources.
		std::shared_ptr<DX::DeviceResources> deviceResources;

		std::unique_ptr<Sample3DSceneRenderer> m_sceneRenderer;

		// Rendering loop timer.
		DX::StepTimer m_timer;

		// Track current input pointer position.
		POINT m_pointerLocation;
	};
}
