#pragma once

#include "targetver.h"

#define WIN32_LEAN_AND_MEAN

// Windows header files
#include <combaseapi.h>
#include <comdef.h>
#include <CommCtrl.h>
#include <PathCch.h>
#include <tchar.h>
#include <wincodec.h>
#include <windowsx.h>
#include <wrl.h>

// DirectX header files
// https://docs.microsoft.com/en-us/windows/desktop/direct3darticles/platform-update-for-windows-7
#include <dxgi1_2.h>
#include <d3d11_1.h>
#include <d2d1_1.h>
#include <d2d1effects_1.h>
#include <dwrite_1.h>
#include <DirectXColors.h>
#include <DirectXMath.h>

#undef max
#undef min

// C++ library header files
#include <cassert>
#include <cstdarg>
#include <algorithm>
#include <fstream>
#include <future>
#include <iterator>
#include <limits>
#include <list>
#include <map>
#include <memory>
#include <mutex>
#include <sstream>
#include <stdexcept>
#include <string>

#include <Twitch.h>

namespace Windows {
	namespace Foundation {
		using Point = POINT;
		struct Size {
			float Width, Height;

			bool operator!=(Size const& that) const {
				return Width != that.Width || Height != that.Height;
			}
		};
	}
}

#ifdef _UNICODE
using tistream = std::wistream;
using tistringstream = std::wistringstream;
using tofstream = std::wofstream;
using tostream = std::wostream;
using tostringstream = std::wostringstream;
using tstringstream = std::wstringstream;
#else
using tistream = std::istream;
using tistringstream = std::istringstream;
using tofstream = std::ofstream;
using tostream = std::ostream;
using tostringstream = std::ostringstream;
using tstringstream = std::stringstream;
#endif

constexpr Twitch::string_t defaultScopes = _T("user:read:email clips:edit");

inline Twitch::tstring ConstructTimeString(time_t time) {
	TCHAR sz[99];
	_tctime64_s(sz, &time);
	sz[24] = _T('\0'); // Remove NL.
	return sz;
}
