#include "pch.h"
#ifdef __ORBIS__
# include <web_browser_dialog.h>
#endif
#include "../Shared/Internal.h"
#include "../Shared/HttpUtil.h"
#include "Utilities.h"

#ifdef _WIN32
# ifdef _UNICODE
#  define __imp_ShellExecute __imp_ShellExecuteW
# else
#  define __imp_ShellExecute __imp_ShellExecuteA
# endif
extern "C" {
	uintptr_t __imp_ShellExecute;
}
#endif

using namespace Microsoft::VisualStudio::CppUnitTestFramework;
using namespace Twitch;

namespace WindowsLibTest {
	TEST_CLASS(AuthTest) {
public:
	TEST_METHOD(UrlEncode_Success) {
#ifdef _UNICODE
		auto result = UrlEncode(_T("\x99a!b@c#d$e%f^g&h*i(j)k-l_m=n+o`p~q[r{s]t}u\\v|w;x:y'z\"0/1?2,3<4.5>\x99"));
		Assert::AreEqual(tstring(_T("%E0%A6%9A!b@c%23d%24e%25f%5Eg%26h*i(j)k-l_m%3Dn%2Bo%60p~q%5Br%7Bs%5Dt%7Du%5Cv%7Cw;x:y'z%220%2F1%3F2,3%3C4.5%3E%C2%99")), result);
#else
		auto result = UrlEncode(_T("\x99 a!b@c#d$e%f^g&h*i(j)k-l_m=n+o`p~q[r{s]t}u\\v|w;x:y'z\"0/1?2,3<4.5>\x99"));
		Assert::AreEqual(tstring(_T("%99%20a!b@c%23d%24e%25f%5Eg%26h*i(j)k-l_m%3Dn%2Bo%60p~q%5Br%7Bs%5Dt%7Du%5Cv%7Cw;x:y'z%220%2F1%3F2,3%3C4.5%3E%99")), result);
#endif
	}

#ifdef _WIN32
	static bool ShellExecute_invoked;
	static HINSTANCE test_ShellExecute(HWND, LPCSTR, LPCSTR, LPCSTR, LPCSTR, INT) {
		ShellExecute_invoked = true;
		return GetModuleHandle(nullptr);
	}
#endif

	TEST_METHOD(ClientAuth_Success) {
#ifdef _XBOX_ONE
		Utilities::WriteWarning("no client auth on Xbox One");
		Assert::IsTrue(true);
#else
# ifdef _WIN32
		__imp_ShellExecute = reinterpret_cast<decltype(__imp_ShellExecute)>(test_ShellExecute);
# endif
		ClientAuth clientAuth;
		auto tokenTask = clientAuth.StartAuth(_T("clientId"), _T("redirect:uri"), Utilities::scopes);
		tstring token;
		auto fn = [&token, &tokenTask] {
			token = tokenTask.get();
		};
		auto waitTask = std::async(std::launch::async, fn);
		clientAuth.Cancel();
		waitTask.get();
		Assert::IsTrue(token.empty());
# ifdef __ORBIS__
		sceWebBrowserDialogTerminate();
# endif
# ifdef _WIN32
		Assert::IsTrue(ShellExecute_invoked);
# endif
#endif
	}

	TEST_METHOD(ClientAuth_StartAuthTwice) {
#ifdef _XBOX_ONE
		Utilities::WriteWarning("no client auth on Xbox One");
		Assert::IsTrue(true);
#else
		ClientAuth clientAuth;
		auto task = clientAuth.StartAuth(_T("clientId"), _T("redirect:uri"), Utilities::scopes);
		Assert::ExpectException<TwitchException>([&clientAuth] { clientAuth.StartAuth(_T("clientId"), _T("redirect:uri"), Utilities::scopes); });
# ifdef __ORBIS__
		sceWebBrowserDialogTerminate();
# endif
#endif
	}

	TEST_METHOD(ClientAuth_BadRedirectUri) {
#ifdef _XBOX_ONE
		Utilities::WriteWarning("no client auth on Xbox One");
		Assert::IsTrue(true);
#else
		ClientAuth clientAuth;
		Assert::ExpectException<TwitchException>([&clientAuth] { clientAuth.StartAuth(_T("clientId"), _T("redirectUri"), Utilities::scopes); });
# ifdef __ORBIS__
		sceWebBrowserDialogTerminate();
# endif
#endif
	}

	TEST_METHOD(ServerAuth_Success) {
		ServerAuth serverAuth;
		tstring state;
		serverAuth.StartAuth(_T("clientId"), _T("redirectUri"), Utilities::scopes, state);
		Assert::IsTrue(state.size() == 32);
		serverAuth.Finish(_T("accessToken"), _T("refreshToken"));
		auto accessToken = serverAuth.AccessToken;
		Assert::AreEqual(tstring(_T("accessToken")), accessToken);
#ifdef __ORBIS__
		sceWebBrowserDialogTerminate();
#endif
	}

	TEST_METHOD(ApplicationAuth_Success) {
		ApplicationAuth applicationAuth;
		auto future = applicationAuth.StartAuth(_T("8jtw1bl78ng6xej11rt191bofwsop0"), _T("j6sboevtib20b1nv0u575i8xna179q"), _T(""));
		auto accessToken = future.get();
		Assert::IsFalse(accessToken.empty());
	}
	};

#ifdef _WIN32
	bool AuthTest::ShellExecute_invoked;
#endif
}
