#include "pch.h"
#include "../Shared/Internal.h"
#include "Utilities.h"

#if defined(_WIN32) && !defined(_XBOX_ONE)
namespace Microsoft {
	namespace VisualStudio {
		namespace CppUnitTestFramework {
			template<>
			static std::wstring ToString<int64_t>(int64_t const& t) {
				RETURN_WIDE_STRING(t);
			}
		}
	}
}
#endif

using namespace Microsoft::VisualStudio::CppUnitTestFramework;
using namespace Twitch;
using namespace Utilities;

namespace WindowsLibTest {
	TEST_CLASS(FollowTest) {
public:
	TEST_METHOD(FetchFollowers_Success) {
		FollowersRequest followersRequest;
		auto followersResponse = followersRequest.Fetch(clientId, token, userId).get();
		Assert::AreEqual(followersResponse.Followers.empty(), followersResponse.Cursor.empty());
		for(auto const& follower : followersResponse.Followers) {
			Assert::AreNotEqual(tstring(_T("")), follower.UserId);
			Assert::AreNotEqual(0ll, follower.FollowedAt);
		}
	}

	TEST_METHOD(FetchFollowers_Fail) {
		FollowersRequest followersRequest;
		Assert::ExpectException<TwitchException>([&followersRequest] { followersRequest.Fetch(clientId, token, invalidUserId).get(); });
	}
	};
}
