#include "pch.h"
#include "../Shared/Internal.h"
#include "Utilities.h"

using namespace Microsoft::VisualStudio::CppUnitTestFramework;
using namespace Twitch;

namespace WindowsLibTest {
	TEST_CLASS(PlayerTest) {
private:
#if defined(_WIN32) && !defined(_XBOX_ONE)
	struct D3D11Device1 : ID3D11Device1 {
	public:
		// ID3D11Device1
		void STDMETHODCALLTYPE GetImmediateContext1(ID3D11DeviceContext1** ppImmediateContext) override {}
		HRESULT STDMETHODCALLTYPE CreateDeferredContext1(UINT ContextFlags, ID3D11DeviceContext1** ppDeferredContext) override { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateBlendState1(D3D11_BLEND_DESC1 const* pBlendStateDesc, ID3D11BlendState1** ppBlendState) override { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateRasterizerState1(D3D11_RASTERIZER_DESC1 const* pRasterizerDesc, ID3D11RasterizerState1** ppRasterizerState) override { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateDeviceContextState(UINT Flags, D3D_FEATURE_LEVEL const* pFeatureLevels, UINT FeatureLevels, UINT SDKVersion, REFIID EmulatedInterface, D3D_FEATURE_LEVEL* pChosenFeatureLevel, ID3DDeviceContextState** ppContextState) override { return S_OK; }
		HRESULT STDMETHODCALLTYPE OpenSharedResource1(HANDLE hResource, REFIID returnedInterface, void** ppResource) override { return S_OK; }
		HRESULT STDMETHODCALLTYPE OpenSharedResourceByName(LPCWSTR lpName, DWORD dwDesiredAccess, REFIID returnedInterface, void** ppResource) override { return S_OK; }

		// ID3D11Device
		HRESULT STDMETHODCALLTYPE CreateBuffer(D3D11_BUFFER_DESC const* pDesc, D3D11_SUBRESOURCE_DATA const* pInitialData, ID3D11Buffer** ppBuffer) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateTexture1D(D3D11_TEXTURE1D_DESC const* pDesc, D3D11_SUBRESOURCE_DATA const* pInitialData, ID3D11Texture1D** ppTexture1D) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateTexture2D(D3D11_TEXTURE2D_DESC const* pDesc, D3D11_SUBRESOURCE_DATA const* pInitialData, ID3D11Texture2D** ppTexture2D) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateTexture3D(D3D11_TEXTURE3D_DESC const* pDesc, D3D11_SUBRESOURCE_DATA const* pInitialData, ID3D11Texture3D** ppTexture3D) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateShaderResourceView(ID3D11Resource* pResource, D3D11_SHADER_RESOURCE_VIEW_DESC const* pDesc, ID3D11ShaderResourceView** ppSRView) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateUnorderedAccessView(ID3D11Resource* pResource, D3D11_UNORDERED_ACCESS_VIEW_DESC const* pDesc, ID3D11UnorderedAccessView** ppUAView) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateRenderTargetView(ID3D11Resource* pResource, D3D11_RENDER_TARGET_VIEW_DESC const* pDesc, ID3D11RenderTargetView** ppRTView) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateDepthStencilView(ID3D11Resource* pResource, D3D11_DEPTH_STENCIL_VIEW_DESC const* pDesc, ID3D11DepthStencilView** ppDepthStencilView) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateInputLayout(D3D11_INPUT_ELEMENT_DESC const* pInputElementDescs, UINT NumElements, void const* pShaderBytecodeWithInputSignature, SIZE_T BytecodeLength, ID3D11InputLayout** ppInputLayout) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateVertexShader(void const* pShaderBytecode, SIZE_T BytecodeLength, ID3D11ClassLinkage* pClassLinkage, ID3D11VertexShader** ppVertexShader) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateGeometryShader(void const* pShaderBytecode, SIZE_T BytecodeLength, ID3D11ClassLinkage* pClassLinkage, ID3D11GeometryShader** ppGeometryShader) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateGeometryShaderWithStreamOutput(void const* pShaderBytecode, SIZE_T BytecodeLength, D3D11_SO_DECLARATION_ENTRY const* pSODeclaration, UINT NumEntries, UINT const* pBufferStrides, UINT NumStrides, UINT RasterizedStream, ID3D11ClassLinkage* pClassLinkage, ID3D11GeometryShader** ppGeometryShader) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreatePixelShader(void const* pShaderBytecode, SIZE_T BytecodeLength, ID3D11ClassLinkage* pClassLinkage, ID3D11PixelShader** ppPixelShader) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateHullShader(void const* pShaderBytecode, SIZE_T BytecodeLength, ID3D11ClassLinkage* pClassLinkage, ID3D11HullShader** ppHullShader) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateDomainShader(void const* pShaderBytecode, SIZE_T BytecodeLength, ID3D11ClassLinkage* pClassLinkage, ID3D11DomainShader** ppDomainShader) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateComputeShader(void const* pShaderBytecode, SIZE_T BytecodeLength, ID3D11ClassLinkage* pClassLinkage, ID3D11ComputeShader** ppComputeShader) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateClassLinkage(ID3D11ClassLinkage** ppLinkage) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateBlendState(D3D11_BLEND_DESC const* pBlendStateDesc, ID3D11BlendState** ppBlendState) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateDepthStencilState(D3D11_DEPTH_STENCIL_DESC const* pDepthStencilDesc, ID3D11DepthStencilState** ppDepthStencilState) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateRasterizerState(D3D11_RASTERIZER_DESC const* pRasterizerDesc, ID3D11RasterizerState** ppRasterizerState) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateSamplerState(D3D11_SAMPLER_DESC const* pSamplerDesc, ID3D11SamplerState** ppSamplerState) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateQuery(D3D11_QUERY_DESC const* pQueryDesc, ID3D11Query** ppQuery) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreatePredicate(D3D11_QUERY_DESC const* pPredicateDesc, ID3D11Predicate** ppPredicate) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateCounter(D3D11_COUNTER_DESC const* pCounterDesc, ID3D11Counter** ppCounter) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CreateDeferredContext(UINT ContextFlags, ID3D11DeviceContext** ppDeferredContext) { return S_OK; }
		HRESULT STDMETHODCALLTYPE OpenSharedResource(HANDLE hResource, REFIID ReturnedInterface, void** ppResource) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CheckFormatSupport(DXGI_FORMAT Format, UINT* pFormatSupport) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CheckMultisampleQualityLevels(DXGI_FORMAT Format, UINT SampleCount, UINT* pNumQualityLevels) { return S_OK; }
		void STDMETHODCALLTYPE CheckCounterInfo(D3D11_COUNTER_INFO* pCounterInfo) {}
		HRESULT STDMETHODCALLTYPE CheckCounter(D3D11_COUNTER_DESC const* pDesc, D3D11_COUNTER_TYPE* pType, UINT* pActiveCounters, LPSTR szName, UINT* pNameLength, LPSTR szUnits, UINT* pUnitsLength, LPSTR szDescription, UINT* pDescriptionLength) { return S_OK; }
		HRESULT STDMETHODCALLTYPE CheckFeatureSupport(D3D11_FEATURE Feature, void* pFeatureSupportData, UINT FeatureSupportDataSize) { return S_OK; }
		HRESULT STDMETHODCALLTYPE GetPrivateData(REFGUID guid, UINT* pDataSize, void* pData) { return S_OK; }
		HRESULT STDMETHODCALLTYPE SetPrivateData(REFGUID guid, UINT DataSize, void const* pData) { return S_OK; }
		HRESULT STDMETHODCALLTYPE SetPrivateDataInterface(REFGUID guid, IUnknown const* pData) { return S_OK; }
		D3D_FEATURE_LEVEL STDMETHODCALLTYPE GetFeatureLevel() { return D3D_FEATURE_LEVEL::D3D_FEATURE_LEVEL_11_1; }
		UINT STDMETHODCALLTYPE GetCreationFlags() { return 0; }
		HRESULT STDMETHODCALLTYPE GetDeviceRemovedReason() { return S_OK; }
		void STDMETHODCALLTYPE GetImmediateContext(ID3D11DeviceContext** ppImmediateContext) {}
		HRESULT STDMETHODCALLTYPE SetExceptionMode(UINT RaiseFlags) { return S_OK; }
		UINT STDMETHODCALLTYPE GetExceptionMode() { return 0; }

		// IUnknown
		HRESULT STDMETHODCALLTYPE QueryInterface(REFIID riid, void** ppvObject) {
			if(riid == __uuidof(ID3D11Device1)) {
				*ppvObject = static_cast<ID3D11Device1*>(this);
			} else if(riid == __uuidof(ID3D11Device)) {
				*ppvObject = static_cast<ID3D11Device*>(this);
			} else if(riid == __uuidof(IUnknown)) {
				*ppvObject = static_cast<IUnknown*>(this);
			} else {
				return E_NOINTERFACE;
			}
			return S_OK;
		}
		ULONG STDMETHODCALLTYPE AddRef() { return 2; }
		ULONG STDMETHODCALLTYPE Release() { return 1; }
	} device;
#endif

	class TestObserver : public Twitch::Player::Observer {
	public:
		TestObserver() = default;
		~TestObserver() override = default;
		void OnDurationChanged(double) override {}
		void OnError(tstring const&) override {
			if(promise) {
				promise->set_value();
			}
		}
		void OnPositionChanged(double) override {}
		void OnRebuffering() override {}
		void OnSeekCompleted(double) override {}
		void OnStateChanged(Twitch::Player::PlayerState) override {}

		std::unique_ptr<std::promise<void>> promise;
	} observer;

public:
	TEST_METHOD(Create_Success) {
#ifdef _WIN32
		auto onRender = [](ID3D11Texture2D* /*texture*/, int /*width*/, int /*height*/) {
			throw std::runtime_error("unexpected onRender invocation");
		};
# ifdef _XBOX_ONE
		Player player(observer, g_device, onRender);
#else
		Player player(observer, &device, onRender);
# endif
#endif
#ifdef __ORBIS__
		Player player(observer);
#endif
	}

	TEST_METHOD(Load_Failure) {
		observer.promise = std::make_unique<std::promise<void>>();
#ifdef _WIN32
		auto onRender = [](ID3D11Texture2D* /*texture*/, int /*width*/, int /*height*/) {
			throw std::runtime_error("unexpected onRender invocation");
		};
# ifdef _XBOX_ONE
		Player player(observer, g_device, onRender);
#else
		Player player(observer, &device, onRender);
# endif
#endif
#ifdef __ORBIS__
		Player player(observer);
#endif
		player.Load(_T("https://localhost"));
		observer.promise->get_future().get();
		observer.promise.reset();
	}
	};
}
