#include "pch.h"
#include "../Shared/Internal.h"

using namespace Microsoft::VisualStudio::CppUnitTestFramework;
using namespace Twitch;

namespace WindowsLibTest {
	TEST_CLASS(TokenTest) {
public:
	TEST_METHOD(ExtractToken_Success) {
		// This is an example of the result of client auth.
		tstring const expectedToken = _T("kevsj4jgjdz56agd1poxp8srzg5mr3");
		tstring const expectedState = _T("jbDOlOhKnJPccFongiHBDHbiCjahgIHJ");
		tstring const text = _T("access_token=") + expectedToken + _T("&scope=user%3Aread%3Aemail&state=") + expectedState;
		auto actualToken = ExtractToken(text, _T("access_token"));
		Assert::AreEqual(expectedToken, actualToken);
		auto actualState = ExtractToken(text, _T("state"));
		Assert::AreEqual(expectedState, actualState);
	}

	TEST_METHOD(ExtractToken_Failure) {
		tstring const text = _T("twitch-game-sdk://twitch.tv/auth?error=redirect_mismatch&error_description=Parameter+redirect_uri+does+not+match+registered+URI&state=kdpBfFoiJbjpFcCcilhghAMPEfPFMinp");
		auto result = ExtractToken(text);
		Assert::IsTrue(result.empty());
	}
	};
}
