#pragma once

#include <string>
#ifdef _UNICODE
using tstring = std::wstring;
#else
using tstring = std::string;
#endif

#if defined(__ORBIS__) || defined(_XBOX_ONE)
# include <cstring>
# include <functional>
# include <iostream>
# include <stdexcept>

# define TEST_CLASS(className) class className
# define TEST_METHOD(methodName) void methodName()
# ifdef __ORBIS__
#  define ERROR_TIMEOUT ETIMEDOUT
#  define FromPlatformError(error) static_cast<int>(SCE_ERROR_MAKE_ERROR(0, error))
#  define _T(s) s
#  define UNREFERENCED_PARAMETER(p) ((void)p)

using TCHAR = char;
using LPTSTR = TCHAR*;
# else
#  define FromPlatformError HRESULT_FROM_WIN32
# endif
# define ERROR_CANNOT_CONNECT 12029

namespace Microsoft {
	namespace VisualStudio {
		namespace CppUnitTestFramework {
			namespace Assert {
				template<typename T, typename U>
				void AreEqual(T expected, U actual) {
					if(expected != actual) {
						throw std::logic_error("equal expectation not met");
					}
				}

				template<typename T, typename U>
				void AreNotEqual(T expected, U actual) {
					if(expected == actual) {
						throw std::logic_error("non-equal expectation not met");
					}
				}

				template<>
				inline void AreEqual(char const* expected, char const* actual) {
					if(std::strcmp(expected, actual)) {
						throw std::logic_error("equal expectation not met");
					}
				}

				template<>
				inline void AreNotEqual(char const* expected, char const* actual) {
					if(!std::strcmp(expected, actual)) {
						throw std::logic_error("non-equal expectation not met");
					}
				}

				inline void IsFalse(bool value) {
					if(value) {
						throw std::logic_error("false expectation not met");
					}
				}

				inline void IsTrue(bool value) {
					if(!value) {
						throw std::logic_error("true expectation not met");
					}
				}

				inline void Fail(tstring const& message) {
					throw std::logic_error(std::string(message.cbegin(), message.cend()));
				}

				template<typename T>
				void ExpectException(std::function<void()> fn) {
					try {
						fn();
					} catch(T const&) {
						return;
					}
					throw std::logic_error("exception expectation not met");
				}
			}
			namespace Logger {
				inline void WriteMessage(char const* message) {
					std::cout << "LOG:  " << message << std::endl;
				}
			}
		}
	}
}
#else
# include "targetver.h"
# include "CppUnitTest.h"
# include <WinSock2.h>
# include <WS2tcpip.h>
# include <winhttp.h>
# include <tchar.h>
# include <ppltasks.h>

# include <future>
# include <thread>
# include <unordered_set>
# include <vector>
# include <map>
# include <utility>

# define FromPlatformError HRESULT_FROM_WIN32
# define ERROR_CANNOT_CONNECT ERROR_WINHTTP_CANNOT_CONNECT
#endif

#include <fstream>

#ifdef _UNICODE
using tistream = std::wistream;
using tistringstream = std::wistringstream;
using tofstream = std::wofstream;
using tostream = std::wostream;
using tostringstream = std::wostringstream;
using tstringstream = std::wstringstream;
#else
using tistream = std::istream;
using tistringstream = std::istringstream;
using tofstream = std::ofstream;
using tostream = std::ostream;
using tostringstream = std::ostringstream;
using tstringstream = std::stringstream;
#endif
