#include "pch.h"
#include "Internal.h"

#pragma comment(lib, "dxguid.lib")
#pragma comment(lib, "mfplat.lib")
#pragma comment(lib, "mfuuid.lib")
#ifdef _DEBUG
# pragma comment(lib, "../vendor/player-core/build/windows/Win64/external/lib/captiond.lib")
# pragma comment(lib, "../vendor/player-core/build/windows/Win64/external/lib/json11d.lib")
#else
# pragma comment(lib, "../vendor/player-core/build/windows/Win64/external/lib/caption.lib")
# pragma comment(lib, "../vendor/player-core/build/windows/Win64/external/lib/json11.lib")
#endif

using namespace Twitch;

namespace {
	tstring nullGuid = _T("00000000-0000-0000-0000-000000000000");
}

tstring Twitch::GetDeviceId() {
	auto const* keyName = _T("SOFTWARE\\Microsoft\\Cryptography");
	auto const* valueName = _T("MachineGuid");
	RegKey key;
	auto result = RegOpenKeyEx(HKEY_LOCAL_MACHINE, keyName, 0, KEY_READ, &key);
	if(result == ERROR_ACCESS_DENIED) {
		result = RegOpenKeyEx(HKEY_CURRENT_USER, keyName, 0, KEY_READ, &key);
	}
	ReturnIfError(result);
	DWORD type, n = 0;
	result = RegQueryValueEx(key, valueName, nullptr, &type, nullptr, &n);
	ReturnIfError(result);
	tstring deviceId(n / sizeof(tstring::value_type), _T('\0'));
	result = RegQueryValueEx(key, valueName, nullptr, &type, reinterpret_cast<LPBYTE>(&deviceId[0]), &n);
	ReturnIfError(result);
	if(deviceId != nullGuid) {
		_tcslwr_s(&deviceId[0], deviceId.size());
		deviceId.pop_back();
	} else {
		deviceId.clear();
	}
	return deviceId;
}
