#include "pch.h"
#include "Internal.h"

using namespace Twitch;

namespace {
	char const* const sdkPlatform = PLATFORM;
#ifdef UNITY
	char const* const sdkRuntime = "Unity";
#else
	char const* const sdkRuntime = "C++";
#endif

	tstring GetApplicationName() {
		auto* commandLine = GetCommandLine();
		if(commandLine[0] == _T('"')) {
			++commandLine;
			auto* quote = _tcschr(commandLine, _T('"'));
			if(quote != nullptr) {
				*quote = _T('\0');
			}
		} else {
			auto* space = _tcschr(commandLine, _T(' '));
			if(space != nullptr) {
				*space = _T('\0');
			}
		}
		auto const* separator = _tcsrchr(commandLine, _T('\\'));
		if(separator != nullptr) {
			return tstring(separator + 1);
		}
		return commandLine;
	}
}

#include "Analytics.inl"
