#pragma once

// Use the C++ standard templated min and max functions.
#define NOMINMAX

#include <xdk.h>
#include <wrl/client.h>
#include <d3d11_x.h>
#include <DirectXMath.h>
#include <DirectXColors.h>
#include <tchar.h>

#include <algorithm>
#include <future>
#include <memory>
#include <stdexcept>

#include <pix.h>

// Workaround for /permissive- issue specific to the Xbox One XDK winrt/base.h
#define JSCRIPT_E_CANTEXECUTE _HRESULT_TYPEDEF_(0x89020001U)

#include <winrt/Windows.ApplicationModel.h>
#include <winrt/Windows.ApplicationModel.Core.h>
#include <winrt/Windows.ApplicationModel.Activation.h>
#include <winrt/Windows.Foundation.h>
#include <winrt/Windows.Foundation.Collections.h>
#include <winrt/Windows.UI.Core.h>
#include <winrt/Windows.XBox.Input.h>

namespace DX {
	inline void ThrowIfFailed(HRESULT hr) {
		if(FAILED(hr)) {
			// Set a breakpoint on this line to catch DirectX API errors
			throw std::exception();
		}
	}
}
