#include "pch.h"
#include <winrt/Windows.Networking.Connectivity.h>
#include "Internal.h"

#pragma comment(lib, "dxguid.lib")
#pragma comment(lib, "mfplat.lib")
#pragma comment(lib, "mfuuid.lib")
#pragma comment(lib, "WS2_32.lib")
// TODO:  These don't work.  For now, they're in the XboxOneLib project properties.
#ifdef _DEBUG
# pragma comment(lib, "../vendor/player-core/build/xboxone/WinRT/external/lib/captiond.lib")
# pragma comment(lib, "../vendor/player-core/build/xboxone/WinRT/external/lib/json11d.lib")
#else
# pragma comment(lib, "../vendor/player-core/build/xboxone/WinRT/external/lib/caption.lib")
# pragma comment(lib, "../vendor/player-core/build/xboxone/WinRT/external/lib/json11.lib")
#endif

using namespace Twitch;

namespace {
	GUID nullGuid;
}

tstring Twitch::GetDeviceId() {
	try {
		auto profiles = winrt::Windows::Networking::Connectivity::NetworkInformation::GetConnectionProfiles();
		for(auto profile : profiles) {
			auto id = profile.NetworkAdapter().NetworkAdapterId();
			if(id != nullGuid) {
				TCHAR deviceId[39];
				if(StringFromGUID2(id, deviceId, _countof(deviceId))) {
					deviceId[37] = _T('\0');
					_tcslwr_s(deviceId);
					return deviceId + 1;
				}
			}
		}
	} catch(...) {
		// Ignore errors.
	}
	return _T("");
}
