#include "pch.h"
#include <wrl.h>
#include "mediaplayer/player.hpp"

namespace twitch {
	// TODO

	MediaTime::MediaTime() noexcept {}
	MediaTime::MediaTime(int64_t, uint32_t) noexcept {}
	MediaTime::MediaTime(double) noexcept {}
	MediaTime MediaTime::zero() { return MediaTime(); }
	MediaTime MediaTime::max() { return MediaTime(); }
	MediaTime MediaTime::invalid() { return MediaTime(); }
	MediaTime MediaTime::scaleTo(uint32_t) const { return MediaTime(); }
	MediaTime MediaTime::absolute() const { return MediaTime(); }
	bool MediaTime::valid() const { return false; }
	int MediaTime::compare(MediaTime const&) const { return 0; }

	using Microseconds = std::chrono::microseconds;
	using Milliseconds = std::chrono::milliseconds;
	using Nanoseconds = std::chrono::nanoseconds;

	double MediaTime::seconds() const { return 0.0; }
	Milliseconds MediaTime::milliseconds() const { return Milliseconds(); }
	Microseconds MediaTime::microseconds() const { return Microseconds(); }
	Nanoseconds MediaTime::nanoseconds() const { return Nanoseconds(); }
	MediaTime& MediaTime::operator*=(double) { return *this; }
	MediaTime& MediaTime::operator/=(double) { return *this; }
	MediaTime& MediaTime::operator+=(MediaTime const&) { return *this; }
	MediaTime& MediaTime::operator-=(MediaTime const&) { return *this; }
}

using namespace Twitch;

#include "ListenerImpl.inl"

namespace {
	twitch::MediaTime FromDouble(double time) {
		return time == std::numeric_limits<double>::infinity() ? twitch::MediaTime::max() : twitch::MediaTime(time);
	}

	double ToDouble(twitch::MediaTime const& time) {
		return time == twitch::MediaTime::max() ? std::numeric_limits<double>::infinity() : time.seconds();
	}
}

struct Player::PlayerImpl {
	PlayerImpl(Observer& observer, ID3D11Device1* device, RenderFn onFrame) : listener(observer), device(device), onFrame(onFrame) {
		throw std::logic_error("not implemented");
	}

	ListenerImpl listener;
	ID3D11Device1* device;
	RenderFn onFrame;
};

Player::Player(Observer& observer, ID3D11Device1* device, RenderFn onFrame) {
	pimpl = std::make_unique<PlayerImpl>(observer, device, onFrame);
}

Player::Player(Player&&) noexcept = default;
Player& Player::operator=(Player&&) noexcept = default;

Player::~Player() {}

void Player::Load(tstring const& url) {
	UNREFERENCED_PARAMETER(url);
}

void Player::Play() {
}

void Player::Pause() {
}

bool Player::GetIsSeekable() const {
	return false;
}

double Player::GetDuration() const {
	return 0.0;
}

double Player::GetPosition() const {
	return 0.0;
}

void Player::SetPosition(double position) {
	UNREFERENCED_PARAMETER(position);
}

double Player::GetBufferedPosition() const {
	return 0.0;
}

Player::PlayerState Player::GetState() const {
	return PlayerState::Idle;
}

float Player::GetPlaybackRate() const {
	return 0.0f;
}

void Player::SetPlaybackRate(float playbackRate) {
	UNREFERENCED_PARAMETER(playbackRate);
}

bool Player::GetIsLooping() const {
	return false;
}

void Player::SetIsLooping(bool isLooping) {
	UNREFERENCED_PARAMETER(isLooping);
}

bool Player::GetIsMuted() const {
	return false;
}

void Player::SetIsMuted(bool isMuted) {
	UNREFERENCED_PARAMETER(isMuted);
}

float Player::GetVolume() const {
	return 0.0f;
}

void Player::SetVolume(float volume) {
	UNREFERENCED_PARAMETER(volume);
}
