package harness

import (
	"net"

	"code.justin.tv/devhub/gdaas-ingest/libs/session"
)

type link struct {
	addr net.Addr
	bind session.Binding
}

var _ session.Client = (*link)(nil)

func (l *link) Address() net.Addr { return l.addr }

func (l *link) WriteText(msg string) error {
	l.bind.OnTextMessage(msg)
	return nil
}

func (l *link) WriteBinary(msg []byte) error {
	l.bind.OnBinaryMessage(msg)
	return nil
}

func (l *link) Close(err error) {
	l.bind.OnClosed(err)
}

func (l *link) WriteBinaryAsText(msg []byte) error {
	l.bind.OnTextMessage(string(msg))
	return nil
}
