package harness

import "code.justin.tv/devhub/gdaas-ingest/libs/session"

// Service provides a test enviornment for a factory.
type Service interface {
	Connect(driver Driver)
}

type service struct {
	factory session.BindingFactory
}

func NewService(factory session.BindingFactory) Service {
	return &service{factory}
}

func (s *service) Connect(driver Driver) {
	bind := s.factory(driver)
	driver.attach(&link{driver.Address(), bind})
}
