package logging

type Level uint8

const (
	Trace   Level = 0
	Debug   Level = 1
	Info    Level = 2
	Warning Level = 3
	Error   Level = 4
	Default Level = Warning
)

func ParseLevel(value string) Level {
	switch value {
	case "0":
		return Trace
	case "trace":
		return Trace
	case "1":
		return Debug
	case "debug":
		return Debug
	case "2":
		return Info
	case "info":
		return Info
	case "3":
		return Warning
	case "warning":
		return Warning
	case "4":
		return Error
	case "error":
		return Error
	}
	return Default
}
