package websocket

import (
	"net"

	"code.justin.tv/devhub/gdaas-ingest/libs/logging"
	"code.justin.tv/devhub/gdaas-ingest/libs/session"
	"github.com/gobwas/ws"
)

type link struct {
	conn    net.Conn
	mask    func(f ws.Frame) ws.Frame
	onClose func(error)
	logger  logging.Function
}

var _ session.Client = (*link)(nil)

func (w *link) Address() net.Addr { return w.conn.RemoteAddr() }

func (w *link) WriteText(content string) error {
	return w.writeFrame(ws.NewTextFrame([]byte(content)))
}

func (w *link) WriteBinaryAsText(content []byte) error {
	return w.writeFrame(ws.NewTextFrame(content))
}

func (w *link) WriteBinary(content []byte) error {
	return w.writeFrame(ws.NewBinaryFrame(content))
}

func (w *link) Close(err error) { w.onClose(err) }

func (w *link) writeClose(code ws.StatusCode, reason string) {
	w.writeFrame(ws.NewCloseFrame(ws.NewCloseFrameBody(code, reason)))
}

func (w *link) writeFrame(frame ws.Frame) error {
	body, err := ws.CompileFrame(w.mask(frame))
	if err != nil {
		return err
	}
	_, err = w.conn.Write(body) // is thread safe (https://golang.org/pkg/net/#Conn)
	if err != nil {
		w.logger(logging.Debug, "Write error", w.Address(), frame.Header.OpCode, err)
	}
	return err
}
