package websocket

import (
	"crypto/tls"
	"net"
	"time"

	"code.justin.tv/devhub/gdaas-ingest/libs/logging"
	"code.justin.tv/devhub/gdaas-ingest/libs/timeout"
	"code.justin.tv/extensions/shutdown"
)

const defaultDuration = 10 * time.Second

type Settings struct {
	Certs     *tls.Config
	Logger    logging.Function
	Lifecycle shutdown.Manager
	Timeout   timeout.Sampler
}

func fixup(settings *Settings) *Settings {
	out := &Settings{settings.Certs, settings.Logger, settings.Lifecycle, settings.Timeout}
	if out.Timeout == nil {
		out.Timeout = timeout.NewConstantSampler(defaultDuration)
	}
	if out.Logger == nil {
		out.Logger = logging.Noop
	}
	return out
}

func (s *Settings) gracefulClose(c net.Conn) error {
	err := filterClosed(c.Close())
	if err == nil {
		s.Logger(logging.Debug, "Closed:", c.RemoteAddr())
	}
	return err
}
