package models

// Payload should have customized structure for each games
// I would expect game devs could define their own payload structure in dev site and we generate a model for them on the run
// But I'm currently defining a fixed structure just for spin up infra and get more feedback first
// Or we could provide a template of supported fields. Need more product discussion.
type DeltaDataPayload struct {
	Positions []Position `json:"position"`
	Resources []int      `json:"resources"`
	// Fields that are very specific to games and we do not do aggregation
	CustomizedData []byte `json:"customized_data"`
	UpdatedAt      int    `json:"updated_at"`
}

type FullStateDataPayload struct {
	Positions []Position `json:"position"`
	Resources []int      `json:"resources"`
	// Fields that are very specific to games and we do not do aggregation
	CustomizedData []byte `json:"customized_data"`
	UpdatedAt      int    `json:"updated_at"`
}

type ConnectDataPayload struct {
	Token         string               `json:"token"`
	FullStateData FullStateDataPayload `json:"full_state_data"`
}
