package jdelta

import (
	"errors"
)

// Patch delta operations into a full state map
func PatchDeltas(fullState map[string]interface{}, deltaStr []interface{}) (map[string]interface{}, error) {
	for _, delta := range deltaStr {
		if array, ok := delta.([]interface{}); ok {
			if len(array) == 0 {
				return nil, errors.New("empty delta message")
			}

			if m, ok := array[0].(map[string]interface{}); ok {
				fullState = m
			} else {
				if err := deltaToFullState(fullState, array); err != nil {
					return nil, err
				}
			}
		} else {
			return nil, errors.New("invalid delta format")
		}
	}

	return fullState, nil
}
