package jdelta

import (
	"errors"
	"strconv"
)

func processPathNode(fullState interface{}, pathNodes []pathNode) (Executor, error) {
	// {{Value: "x", Op: 0}, {Value: "y", Op: 0}, {Value: "0", Op: 1}}
	if len(pathNodes) == 0 {
		return nil, errors.New("wrong indexing")
	}

	var out = fullState
	switch pathNodes[0].Op {
	case 0:
		// in case of map
		if current, ok := (out).(map[string]interface{}); ok {
			if len(pathNodes) == 1 {
				return &mapExecutor{
					out: current,
					key: pathNodes[0].Value,
				}, nil
			} else if val, ok := current[pathNodes[0].Value]; ok {
				if mapExecutor, err := processPathNode(val, pathNodes[1:]); err == nil {
					return mapExecutor, nil
				} else {
					return nil, err
				}
			} else {
				return nil, ErrInvalidMapExpectation
			}
		} else {
			return nil, ErrInvalidMapExpectation
		}
	case 1:
		// in case of array
		if current, ok := (out).([]interface{}); ok {
			if len(pathNodes) == 1 {
				if i, err := strconv.Atoi(pathNodes[0].Value); err == nil {
					return &arrayExecutor{
						out:   current,
						index: i,
					}, nil
				}
				return nil, errors.New("fail to change index into integer")
			} else {
				if i, err := strconv.Atoi(pathNodes[0].Value); err == nil {
					if arrayExecutor, err := processPathNode(current[i], pathNodes[1:]); err == nil {
						return arrayExecutor, nil
					} else {
						return nil, err
					}
				} else {
					return nil, err
				}
			}
		} else {
			return nil, errors.New("fail to parse path node as array")
		}
	default:
		return nil, errors.New("neither an array or map structure")
	}
}

// need to pass translated tag here
func operateOnExecutor(fullState interface{}, node deltaNode) error {
	pathsNodes, err := parsePath(node.path)
	if err != nil {
		return err
	}
	if executor, err := processPathNode(fullState, pathsNodes); err == nil {
		switch node.operation {
		case "add": // for add or replace
			if err := executor.Set(node.value); err != nil {
				return err
			}
		case "remove": // for remove
			if err := executor.Clear(); err != nil {
				return err
			}
		case "append":
			if err := executor.Append(node.value); err != nil {
				return err
			}
		}
	} else {
		return err
	}
	return nil
}
