package jdelta

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestProcessPathNode(t *testing.T) {
	t.Run("should be able to process map struct without error", func(t *testing.T) {
		pathNodes := []pathNode{{Value: "champion", Op: 0}, {Value: "name", Op: 0}}
		fullState, err := FullStateStringToMap(fullStateStr)
		assert.NoError(t, err)

		executor, err := processPathNode(fullState, pathNodes)
		assert.NoError(t, err)
		assert.NotNil(t, executor)
	})

	t.Run("should be able to process array struct without error", func(t *testing.T) {
		pathNodes := []pathNode{{Value: "champion", Op: 0}, {Value: "resource", Op: 0}, {Value: "1", Op: 1}}
		fullState, err := FullStateStringToMap(fullStateStr)
		assert.NoError(t, err)

		executor, err := processPathNode(fullState, pathNodes)
		assert.NoError(t, err)
		assert.NotNil(t, executor)
	})

	t.Run("should be able to add a map struct without error", func(t *testing.T) {
		pathNodes := []pathNode{{Value: "a", Op: 0}}
		fullState, err := FullStateStringToMap(fullStateStr)
		assert.NoError(t, err)

		executor, err := processPathNode(fullState, pathNodes)
		assert.NoError(t, err)
		assert.NotNil(t, executor)
	})

	t.Run("should be able to process multi-dimension array without error", func(t *testing.T) {
		pathNodes := []pathNode{{Value: "position", Op: 0}}
		fullState, err := FullStateStringToMap(fullStateStr)
		assert.NoError(t, err)

		executor, err := processPathNode(fullState, pathNodes)
		assert.NoError(t, err)
		assert.NotNil(t, executor)
	})
}
