package jdelta

import (
	"reflect"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestParseDeltaStringIntoStruct(t *testing.T) {
	t.Run("should parse with right array interface", func(t *testing.T) {
		deltas, err := DeltaStateStringToOperationArray(`[["a"], ["b", ["new_value1", "new_value2"]], ["c", "a", [1,2]] ]`)
		assert.NoError(t, err)

		assert.Equal(t, len(deltas), 3)

		targetArrayOne := make([]interface{}, 1)
		targetArrayOne[0] = "a"

		targetArrayTwo := make([]interface{}, 2)
		targetArrayTwo[0] = "b"
		subTargetArrayString := make([]interface{}, 2)
		subTargetArrayString[0] = "new_value1"
		subTargetArrayString[1] = "new_value2"
		targetArrayTwo[1] = subTargetArrayString

		targetArrayThree := make([]interface{}, 3)
		targetArrayThree[0] = "c"
		targetArrayThree[1] = "a"
		subTargetArrayNum := make([]interface{}, 2)
		subTargetArrayNum[0] = float64(1)
		subTargetArrayNum[1] = float64(2)
		targetArrayThree[2] = subTargetArrayNum

		assert.Equal(t, (deltas)[0], targetArrayOne)
		assert.Equal(t, (deltas)[1], targetArrayTwo)
		assert.True(t, reflect.DeepEqual((deltas)[2], targetArrayThree))
	})
}
