package jdelta

import (
	"errors"
	"strings"
)

// paths := []pathNode{{Value: "x", Op: 0}, {Value: "y", Op: 0}, {Value: "0", Op: 1}}
// For leaf node, it doesn't matter its operation type, since it just contribute to a key
func parsePath(path string) ([]pathNode, error) {
	var paths []pathNode
	if strings.Contains(path, "[]") {
		return nil, errors.New("invalid delta format")
	}

	mapSplited := strings.Split(path, ".")
	for _, mapPath := range mapSplited {
		arraySplited := strings.FieldsFunc(mapPath, SplitArray)
		if len(arraySplited) == 0 {
			return nil, errors.New("invalid delta format")
		}

		paths = append(paths, pathNode{Value: arraySplited[0], Op: 0})
		for _, arrayPath := range arraySplited[1:] {
			paths = append(paths, pathNode{Value: arrayPath, Op: 1})
		}
	}

	return paths, nil
}
