package jdelta

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestParsePath(t *testing.T) {

	t.Run("should parse single layer", func(t *testing.T) {
		pathNodes, err := parsePath("x")
		assert.NoError(t, err)
		assert.Equal(t, pathNodes, []pathNode{{Value: "x", Op: 0}})
	})

	t.Run("should parse map multi layer", func(t *testing.T) {
		pathNodes, err := parsePath("x.y.z")
		assert.NoError(t, err)
		assert.Equal(t, pathNodes, []pathNode{{Value: "x", Op: 0}, {Value: "y", Op: 0}, {Value: "z", Op: 0}})
	})

	t.Run("should parse array multi layer", func(t *testing.T) {
		pathNodes, err := parsePath("x[1][12][0]")
		assert.NoError(t, err)
		assert.Equal(t, pathNodes, []pathNode{{Value: "x", Op: 0}, {Value: "1", Op: 1}, {Value: "12", Op: 1}, {Value: "0", Op: 1}})
	})

	t.Run("should parse combination of map and array layer: case 1", func(t *testing.T) {
		pathNodes, err := parsePath("x.y[10].z")
		assert.NoError(t, err)
		assert.Equal(t, pathNodes, []pathNode{{Value: "x", Op: 0}, {Value: "y", Op: 0}, {Value: "10", Op: 1}, {Value: "z", Op: 0}})
	})

	t.Run("should parse 2 consecutive periods as an error", func(t *testing.T) {
		pathNodes, err := parsePath("x.y..z")
		assert.Error(t, err)
		assert.Nil(t, pathNodes)
	})

	t.Run("should parse empty brackets as an error", func(t *testing.T) {
		pathNodes, err := parsePath("x[].z")
		assert.Error(t, err)
		assert.Nil(t, pathNodes)
	})
}
