package jdelta

import (
	"errors"
)

func translateToDeltaNode(delta []interface{}) (*deltaNode, error) {
	var node deltaNode
	var operation string
	var value interface{}
	switch len(delta) {
	case 1:
		operation = "remove"
	case 2:
		operation = "add" // add or replace
		value = delta[1]
	case 3:
		{
			if opsAlias, ok := (delta[1]).(string); !ok {
				return nil, errors.New("unable to translate operation into string")
			} else {
				switch opsAlias {
				// only have append case for now, maybe adding more later
				case "a":
					operation = "append"
					value = delta[2]
				default:
					return nil, errors.New("invalid operation")
				}
			}
		}
	}
	node.operation = operation
	node.value = value
	if path, ok := delta[0].(string); !ok {
		return nil, errors.New("bad path")
	} else {
		node.path = path
	}

	return &node, nil
}
