package jdelta

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestTranslateToDeltaNode(t *testing.T) {
	t.Run("should add/set to a map value", func(t *testing.T) {
		delta := make([]interface{}, 2)
		delta[0] = "damage"
		delta[1] = 4396
		node, err := translateToDeltaNode(delta)
		assert.NoError(t, err)
		assert.Equal(t, *node, deltaNode{
			value:     4396,
			path:      "damage",
			operation: "add",
		})
	})

	t.Run("should remove a single value", func(t *testing.T) {
		delta := make([]interface{}, 1)
		delta[0] = "damage"
		node, err := translateToDeltaNode(delta)
		assert.NoError(t, err)
		assert.Equal(t, *node, deltaNode{
			path:      "damage",
			operation: "remove",
		})
	})

	t.Run("should remove a map value", func(t *testing.T) {
		delta := make([]interface{}, 1)
		delta[0] = "champion.name"
		node, err := translateToDeltaNode(delta)
		assert.NoError(t, err)
		assert.Equal(t, *node, deltaNode{
			path:      "champion.name",
			operation: "remove",
		})
	})

	t.Run("should dealing with remove of a value", func(t *testing.T) {
		delta := make([]interface{}, 1)
		delta[0] = "damage.y.z[10].o"
		node, err := translateToDeltaNode(delta)
		assert.NoError(t, err)
		assert.Equal(t, *node, deltaNode{
			path:      "damage.y.z[10].o",
			operation: "remove",
		})
	})

	t.Run("should dealing with append a value", func(t *testing.T) {
		delta := make([]interface{}, 3)
		delta[0] = "damage[3].x"
		delta[1] = "a"
		delta[2] = "[1,2]"
		node, err := translateToDeltaNode(delta)
		assert.NoError(t, err)
		assert.Equal(t, *node, deltaNode{
			value:     "[1,2]",
			operation: "append",
			path:      "damage[3].x",
		})
	})
}
