package main

import (
	jdelta "code.justin.tv/devhub/json-delta/lib"
	"encoding/json"
)

func main() {
	deltaStr := `[["foo.bar[0][1].two[1]", 5]]`
	fullStateStr := `{
  "foo": {
    "bar": [[
      {
        "one": [1, 2]
      },
      {
        "two": [3, 4]
      }
    ]]
  }
}
`

	fullState, _ := jdelta.FullStateStringToMap(fullStateStr)
	deltas, _ := jdelta.DeltaStateStringToInterface(deltaStr)
	f, _ := jdelta.PatchDeltas(fullState, deltas)
	result, _ := json.Marshal(f)
	println(string(result))
}
