# Lifecycle

This library provides a clean `lifecycle.Manager` interface for triggering the coordinated `ExecuteAll` of cleanup functions that have been previously added using `RegisterHook`, removing the need to explicitly track opened resources during program execution. Cleanup of individual items can be triggered early using `ExecuteHook`, which removes them from the internal list.

`Manager` also provides a central mechanism that allows the user to halt progress until all background routines registered with `RunUntilComplete` (execute once) or `TickUntilClosed` (execute on timer, close returned channel to stop) have completed, allowing proper completion of any resource cleanup that requires explicit code.

Multiple `lifecycle.Managers` can safely be used in parallel to define nested lifecycle scopes for cleanup of resources associated with program scopes such as requests, sessions, or connections.

As a convenience, `Manager` also provides a `ListenForInterrupt` function function; this call is useful for services that want to block for SIGINT or SIGTERM to and do not otherwise already have a blocking main routine.
