package lifecycle

import (
	"fmt"
)

type CapturedPanic struct {
	msg   string
	value interface{}
	stack []byte
}

var _ error = (*CapturedPanic)(nil)

func PanicToError(value interface{}, stack []byte) *CapturedPanic {
	return &CapturedPanic{"", value, stack}
}

func PanicToErrorWithMessage(msg string, value interface{}, stack []byte) *CapturedPanic {
	return &CapturedPanic{msg, value, stack}
}

func (c *CapturedPanic) Stack() []byte      { return c.stack }
func (c *CapturedPanic) Value() interface{} { return c.value }
func (c *CapturedPanic) Message() string    { return c.msg }

func (c *CapturedPanic) String() string {
	if c.msg != "" {
		return fmt.Sprintf("panic (%s): %v\n%s", c.msg, c.value, string(c.stack))
	}
	return fmt.Sprintf("panic: %v\n%s", c.value, string(c.stack))
}

func (c *CapturedPanic) Error() string { return c.String() }
