package lifecycle

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestCapturedPanic(t *testing.T) {
	assert.Equal(t, "panic: <nil>\n", PanicToError(nil, nil).Error())
	stack := []byte("stack\ngoes\nhere")

	err := PanicToError(1, stack)
	assert.Empty(t, err.Message())
	assert.Equal(t, 1, err.Value())
	assert.Equal(t, stack, err.Stack())
	assert.Equal(t, "panic: 1\nstack\ngoes\nhere", err.Error())

	err = PanicToErrorWithMessage("oops", "not good", stack)
	assert.Equal(t, "oops", err.Message())
	assert.Equal(t, "not good", err.Value())
	assert.Equal(t, stack, err.Stack())
	assert.Equal(t, "panic (oops): not good\nstack\ngoes\nhere", err.Error())
}
