package lifecycle

import (
	"errors"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestErrorList(t *testing.T) {
	list := NewErrorList()
	assert.True(t, list.IsEmpty())
	assert.Empty(t, list.Expand())
	assert.EqualError(t, list, "0 errors")

	expected := errors.New("expected")
	expected2 := errors.New("expected too")
	list.Append(expected)
	list.Append(expected2)
	assert.False(t, list.IsEmpty())
	assert.EqualError(t, list, "2 errors\nexpected\nexpected too")

	assert.Equal(t, []error{expected, expected2}, list.Expand())
	assert.Equal(t, list, NewErrorList(expected, expected2))
}

func TestCombineErrors(t *testing.T) {
	expected := errors.New("expected")
	expected2 := errors.New("expected too")
	expected3 := errors.New("another expected")
	expected4 := errors.New("final expected")

	assert.Nil(t, CombineErrors(nil, nil))
	assert.Equal(t, expected, CombineErrors(expected, nil))
	assert.Equal(t, expected, CombineErrors(nil, expected))
	assert.Equal(t, NewErrorList(expected, expected2), CombineErrors(expected, expected2))
	assert.Equal(t, NewErrorList(expected, expected2, expected3), CombineErrors(CombineErrors(expected, expected2), expected3))
	assert.Equal(t, NewErrorList(expected2, expected3, expected), CombineErrors(expected, CombineErrors(expected2, expected3)))
	assert.Equal(t, NewErrorList(expected, expected4, expected2, expected3), CombineErrors(CombineErrors(expected, expected4), CombineErrors(expected2, expected3)))
}
