package lifecycle

import (
	"errors"
	"sync"
	"testing"
	"time"

	"github.com/stretchr/testify/assert"
)

func TestReporter(t *testing.T) {
	var wg sync.WaitGroup
	wg.Add(2)
	count := 0
	reporter := func(interface{}, error) {
		count = count + 1
		wg.Done()
	}

	SetDefaultErrorReporter(reporter)
	SetDefaultPanicReporter(reporter)

	mgr := NewManager()
	expected := errors.New("expected")
	mgr.RegisterHook("value", func() error { return expected })
	assert.Equal(t, expected, mgr.ExecuteHook("value"))
	assert.Equal(t, 1, count)

	mgr.TickUntilClosed(func() { panic("expected") }, time.Nanosecond)
	wg.Wait()
	assert.Equal(t, 2, count)
}
