# lib-promise

This library provides sharable asynchornous work results. It is meant to be combined with a store that maps a task identifier to a promise instance. This pattern proves useful in the following scenarios:

* Deduplication - when an expensive work request is made, checking the store for an existing promise allows redundant requests for the same work to wait for an existing execution instead of starting a new one, reducing resource consumption and the response delay if the underlying work is already in progress.
* In-process caching - by default the store may want to remove promises as soon as work is completed, but adding an entry timer to the store converts it into an in-process cache that further reduces downstream load.

The choice of task identifier is implementation specific, but simple examples could include an encoded string containing an http endpoint with parameters or a set of DB query parameters.