package promise

// Any provides a generic interface for retrieving a task result; it also provides a check to see if
// that result can be received without blocking the current routine.
type Any interface {
	WouldBlock() bool
	Get() (interface{}, error)
}

// MutableAny allows asynchronous update of an any after creation.
type MutableAny interface {
	Any
	Set(interface{}, error)
}
