package promise

import (
	"sync"
	"sync/atomic"
)

// NewAny creates a MutableAny
func NewAny() MutableAny {
	a := &asyncAny{}
	a.loaded.Add(1)
	return a
}

type asyncAny struct {
	data   interface{}
	err    error
	hasSet int32
	loaded sync.WaitGroup
}

func (a *asyncAny) WouldBlock() bool {
	return atomic.LoadInt32(&a.hasSet) == 0
}

func (a *asyncAny) Get() (interface{}, error) {
	a.loaded.Wait()
	return a.data, a.err
}

func (a *asyncAny) Set(data interface{}, err error) {
	if atomic.SwapInt32(&a.hasSet, 1) == 0 {
		a.data = data
		a.err = err
		a.loaded.Done()
	}
}
